#!/bin/sh

vjunos_install_current_log=/var/log/vjunos-install-current.log
vjunos_install_log=/var/log/vjunos-install.log
vjunos_install_status=/var/run/vjunos-install-status
echo 0 > $vjunos_install_status

(

HYPERVISOR=192.168.1.1
JHOST="jhost"
pkg_dir="/var/tmp"
PREINSTALL_PKG_PATH="/var/tmp/preinstall"
vjunos_install_pending=/var/run/vjunos-install-pending
verify_image_from_host=1
verify_cmd='/sbin/jverify-sig'
unamestr=`uname`
linux_jdm=""
fail=0
pkg_force=$PKG_FORCE_HOST
pkg_issu=$PKG_ISSU
IS_VIRTFS_ENABLED_SYSCTL="hw.product.pvi.config.platform.is_virtfs_enabled"

if [ "$unamestr" = "Linux" ]; then
    linux_jdm=1
    rsh_cmd='rsh'
    rcp_cmd='rcp'
    pkg_force=${pkg_force:-"-f"}
else
    linux_jdm=0
    rsh_cmd='rsh -JU __juniper_private4__'
    rcp_cmd='rcp -JU __juniper_private4__'
fi

echo "========================================" >> $vjunos_install_log
echo "`date -u`" >> $vjunos_install_log
echo $0 $* >>  $vjunos_install_log

local_copy_file() {
    local dest=$2
    cp $1 $dest
    ret=$?
    if [ $ret -ne 0 ]; then
        echo "download_file $1 failed, ret=$ret"
    fi
    sync # flush everything to disk
    
    return $ret
}

download_file() {
    local from=$1
    local dest=$2
    local ret

    if [ ! -f $from ]; then
    echo "download_file $from not found"
    return 1
    fi

    $rcp_cmd $from $HYPERVISOR:$dest
    ret=$?
    if [ $ret -ne 0 ]; then
    echo "download_file $from failed, ret=$ret"
    fi

    return $ret
}

exec_rsh_cmd(){

    local cmd="$1"
    local remote_cmd
    local ret
    local cmd_status_file="/var/run/cmd_status_file"
    total_cmd=${cmd}" echo "'"$?" >/var/run/cmd_status_file'"'"

    remote_cmd="$rsh_cmd $HYPERVISOR"

    $remote_cmd "'$total_cmd'"
    ret=$?
    cmd_e_status=`$remote_cmd "cat $cmd_status_file"`

    if [ -z "$cmd_e_status" ]; then
        cmd_e_status=9;
    fi

    if [ $ret -ne 0 ] || [ $cmd_e_status -ne 0 ]; then
        return 1;
    else
        return 0;
    fi

}

exec_host_cmd() {
    local cmd="$1"
    local remote_cmd
    local ret

    if [ ${linux_jdm} = 1 ]; then
        remote_cmd="$JHOST $cmd"
        $remote_cmd
        ret=$?
    else
        exec_rsh_cmd "'$cmd;"
        ret=$?
    fi

    return $ret
}

check_bios_version_for_nfx3()
{
    local min_bios_v="CBDE_SFP_00.21_01.01"   #NFX250 minimum required bios version
    local curr_bios_v=`$JHOST dmidecode -s bios-version 2>/dev/null | grep CBDE`
    local min_bios_num
    local curr_bios_num

    #Check for expected format and number:   CBDE_XXX_NN.NN_NN.NN
    #Also check that NNNNNNNN is greater than required
    if echo $curr_bios_v | grep -q "^CBDE_..._[0-9][0-9].[0-9][0-9].[0-9][0-9].[0-9][0-9]$" ; then
         curr_bios_num=`echo $curr_bios_v | \
             sed -e "s/CBDE_..._\([0-9][0-9]\).\([0-9][0-9]\).\([0-9][0-9]\).\([0-9][0-9]\)$/\1\2\3\4/g"`
         min_bios_num=`echo $min_bios_v | \
             sed -e "s/CBDE_..._\([0-9][0-9]\).\([0-9][0-9]\).\([0-9][0-9]\).\([0-9][0-9]\)$/\1\2\3\4/g"`
         if [ "$curr_bios_num" -ge "$min_bios_num" ] ; then
             #Current BIOS version looks ok
             return 0
         fi
    fi
    echo "Error: Current bios version $curr_bios_v is older than minimum required ($min_bios_v)"
    return 1
}

host_delete_image() {
    local ret

    if [ ${linux_jdm} = 1 ]; then
        $JHOST find /var/tmp -name "jinstall-*.tgz" | \
        jhost xargs rm >/dev/null 2>&1
        $JHOST find /var/tmp -name "install-media-*.tgz" | \
        jhost xargs rm >/dev/null 2>&1
    else
        # if host's /var is mounted, use local file rm instead of rsh
        if [ -d "/hostvar/tmp" -a "$pkg_dir" = "/var/tmp" ]; then
            mnt_pkg_dir=$(echo $pkg_dir | sed 's/^\/var/\/hostvar/1')
            rm -rf $mnt_pkg_dir/jinstall-*.tgz
            rm -rf $mnt_pkg_dir/install-media-*.tgz
            rm -rf $mnt_pkg_dir/yocto_conversion.sh
            rm -rf $mnt_pkg_dir/yocto_host_conversion.sh
            if [ ${fail} = 1 ]; then
                rm -rf $mnt_pkg_dir/snos_install.tgz
                rm -rf $mnt_pkg_dir/junos_app_install.tgz
            fi
	else
            is_virtfs_enabled=`sysctl -nq $IS_VIRTFS_ENABLED_SYSCTL`
            if [ "$is_virtfs_enabled" != "1" ]; then
                $rsh_cmd $HYPERVISOR rm -rf $pkg_dir/jinstall-*.tgz
                $rsh_cmd $HYPERVISOR rm -rf $pkg_dir/install-media-*.tgz
                $rsh_cmd $HYPERVISOR rm -rf $pkg_dir/yocto_conversion.sh
                $rsh_cmd $HYPERVISOR rm -rf $pkg_dir/yocto_host_conversion.sh
                if [ ${fail} = 1 ]; then
                    $rsh_cmd $HYPERVISOR rm -rf $pkg_dir/snos_install.tgz
                    $rsh_cmd $HYPERVISOR rm -rf $pkg_dir/junos_app_install.tgz
                fi
            fi
        fi
    fi
}

host_install_image() {
    local image="$@"
    local opt_force=$pkg_force
    local opt_cleanup=
    local opt_primary=
    local opt_ci_n_cfg=
    local opt_issu=$pkg_issu

    if [ ! -z ${PKG_CLEAN_INSTALL} ] ; then
        opt_cleanup="-c"
    fi

    if [ ! -z ${PKG_ON_PRIMARY} ] ; then
        opt_primary="-p"
    fi

    if [ ! -z "${HOST_CLEAN_INSTALL_CFG_PATH}" ] ; then
        opt_ci_n_cfg="-c -u ${HOST_CLEAN_INSTALL_CFG_PATH}"
    fi

    if [ ${linux_jdm} = 0 ]; then
        centos_host=`$rsh_cmd $HYPERVISOR "find /etc -name centos-release"`
    fi
    if [ x${centos_host} != x ]; then
        # centos to yocto conversion
        host_cmd="/var/tmp/yocto_host_conversion.sh $image"
        exec_host_cmd "$host_cmd"
        ret=$?
        if [ $ret -ne 0 ] ; then
            echo "Yocto Conversion: Host image copy failed"
            host_delete_image
            return $ret
        fi
        exec_host_cmd "/var/tmp/yocto_conversion.sh"
        ret=$?
        if [ $ret -ne 0 ] ; then
            echo "Yocto Conversion: Host installation failed"
            host_delete_image
            return $ret
        fi
    else
        host_cmd="/usr/sbin/junos-install add $opt_cleanup $opt_ci_n_cfg $opt_primary $image $opt_force $opt_issu"
        exec_host_cmd "$host_cmd"
        ret=$?
    fi

    return $ret
}

package_member() {
    if [ -d "$1"/. ]; then
    # package already unpacked
    (cd $1; shift; cat "$@") 2>/dev/null
    else
        tar -zxO -f "$@" 2>/dev/null
    fi
}

#
# package_name <package-file>
#
# Determine the package name of a given file by looking at the +CONTENTS
# file for the @name field or the +junos-package.xml file for the <name> tag
package_name() {
    local name f

    f=+CONTENTS

    name=`package_member "$1" $f | \
    sed -n -e '/^@name/s,@name ,,p' \
        -e '/<name>/s,.*<name>\([^<]*\)</name>.*,\1,p' 2>/dev/null`
    echo "$name"
}

post_install_jvm_image() {
    local img_pkg=$1
    local jinstall_domestic_stripped=0
    local host_cmd
    local install_media_pkg
    local jinstall_domestic_pkg
    local sig_file
    local is_verify_tool_available
    local pkg_real_name
    local jdm_var_tmp_host_path="/third-party/jdm-var/tmp"
    local upgrade_config_tmp_copy

    pkg_name=`basename $img_pkg`

    pkg_real_name=`package_name ${img_pkg}`


    case ${pkg_real_name} in
    jinstall-*-signed*)
        # signed image
        jinstall_signed_image=1
        ;;
    *) 
        # domestic image
        jinstall_signed_image=0
        ;;
    esac

    case "$pkg_name" in
    *-nfx-3-*)
        # Space optimization for NFX3 case. Switch off for NFX2 (JDM)
        # to NFX3 case
        if [ ${linux_jdm} != 1 ]; then
            # For NFX3, pkg_name is the name of the inner package, so
            # it would have the nfx-3 string in it.
    
            RETAIN_PKG_IN_PREINSTALL_PKG_PATH=1
        fi
        ;;
    *-qfx-5e-*)
        # Override the force host 
        if [ -z "$pkg_issu" ]; then
             model=${model:-`sysctl -n hw.product.model`}
             case ${model} in
             qfx5100*)
                  vc_check=${vc_check:- `sysctl -n hw.vc.enabled`}
                  if [ -z "$vc_check" ]; then
                      echo "##############################################  WARNING  ##############################################"
                      echo "WARNING TVP image (qfx-5e) is NOT supported on QFX5100 standalone or Virtual Chassis (VC)"
                      echo "WARNING TVP image (qfx-5e) on QFX5100 is supported only for line-card role in QFX5110/QFX5100 mixed Virtual Chassis(VC)/ Virtual Chassis Fabric (VCF)"
                      echo "##############################################  WARNING  ##############################################"
                  fi
                  ;;
             *)
                  ;;
             esac
             echo "Forcing the Host Upgrade for Non Issu updates..." 
             pkg_force=${pkg_force:-"-f"}
        fi
        ;;
    *-qfx-10-*)
        # Override the force host 
        if [ -z "$pkg_issu" ]; then
             echo "Forcing the Host Upgrade for Non Issu updates..." 
             pkg_force=${pkg_force:-"-f"}
        fi
        ;;
    *-ex-4300mp-*)
        # Always enforce "force-host" action
        pkg_force="-f"
        ;;
    esac
   
    host_delete_image

    if [ -f "$img_pkg" ]; then
        echo "Pushing Junos image package to the host..."

        sync

        if [ ${linux_jdm} = 1 ]; then

            # The check for nfx-3 below can avoid a lot of user pain. Refuse 
            # ordinary upgrade to NFX-3 from linux_jdm (NFX2) environment.
            # "$img_pkg" can be arbitrary (like foo.tgz) so check contents.
            #
            # Check for "install-media*nfx-3*" or "jinstall*nfx-3*" file
            if ( tar -ztf $img_pkg | grep -sq "install.*-nfx-3-" ) >/dev/null 2>&1 ; then
                if [ -z "$PKG_CLEAN_INSTALL_WITH_CONFIG" -a \
                     -z "$PKG_CLEAN_INSTALL" ] ; then
                     fail=1
                     echo "Error: Current disk layout is not upgrade compatible to package provided"
                     return 1
                fi
                if ! check_bios_version_for_nfx3 ; then
                     fail=1
                     #Error already printed, return failure
                     return 1
                fi
            fi

            echo "Installing $img_pkg" > $vjunos_install_pending
            $JHOST rm -rf ${PREINSTALL_PKG_PATH}
            $JHOST mkdir -p ${PREINSTALL_PKG_PATH}
            $JHOST tar -C ${PREINSTALL_PKG_PATH} -xmzf $jdm_var_tmp_host_path/$pkg_name
            if [ $? -ne 0 ]; then
                $JHOST rm -rf ${PREINSTALL_PKG_PATH}
                echo "Error: failed to extract $pkg_name" 
                return 1
            fi

            if [ ! -z "$PKG_CLEAN_INSTALL_WITH_CONFIG" ] ; then 
                upgrade_config_tmp_copy=`mktemp --tmpdir=/var/tmp --suffix=.ci_upg_cfg 2>/dev/null`
                if [ -z "$upgrade_config_tmp_copy" ] ||
                   ! cp $PKG_CLEAN_INSTALL_WITH_CONFIG $upgrade_config_tmp_copy 2>/dev/null ; then
                   echo "Error: Could not copy post upgrade config"
                   return 1
                fi
                HOST_CLEAN_INSTALL_CFG_PATH=$jdm_var_tmp_host_path/`basename $upgrade_config_tmp_copy`
            fi

            if [ ${jinstall_signed_image} = 1 ]; then
               is_verify_tool_available=`$JHOST ls $verify_cmd 2> /dev/null`
               if [ x${is_verify_tool_available} != x ]; then
                   if [ ${verify_image_from_host} -eq 1 ] ; then
                       sig_file=`$JHOST find ${PREINSTALL_PKG_PATH} -name "jinstall-*.tgz.sig"`
                       if [ x${sig_file} != x ]; then
                           retval=`$JHOST $verify_cmd -b -c ${PREINSTALL_PKG_PATH}/certs.pem $sig_file > /dev/null 2>&1 ; echo $?`
                           if [ ${retval} -ne 0 ]; then
                               fail=1
                               echo "Error: Validating signature for $pkg_name failed!" 
                           else
                               echo "Validating signature for $pkg_name success"
                           fi
                       else
                           fail=1
                           echo "Error: signature file for $pkg_name not found"
                       fi
                   fi
               else
                   echo "Validating signature for $pkg_name in hostos not supported" >> $vjunos_install_log
                   echo "Skipping signature validation for $pkg_name"
               fi
            fi

            if [ $fail -ne 1 ]; then
                jinstall_domestic_pkg=`$JHOST find ${PREINSTALL_PKG_PATH} -name "jinstall-*.tgz"`
                if [ x${jinstall_domestic_pkg} != x ]; then
                    $JHOST tar -C ${PREINSTALL_PKG_PATH} -xmzf $jinstall_domestic_pkg
                    if [ $? -ne 0 ]; then
                        fail=1
                        echo "Error: failed to extract jinstall package" 
                    fi
                fi

                if [ $fail -ne 1 ]; then
                        install_media_pkg=`$JHOST find ${PREINSTALL_PKG_PATH} -name "install-media-*.tgz"`
                        if [ x${install_media_pkg} != x ]; then
                            $JHOST mv $install_media_pkg /var/tmp/
                        else
                            fail=1
                            echo "Error: installation package not found"
                        fi
                fi
            fi
            # Cleanup /var/tmp/preinstall before proceeding further
            $JHOST rm -rf ${PREINSTALL_PKG_PATH}

            if [ $fail -eq 1 ]; then
                return 1
            fi
        else
            echo "Downloading Junos image package..." >> $vjunos_install_log
            # use local file copy if hostvar is mounted.
            if [ -d "/hostvar/tmp" -a "$pkg_dir" = "/var/tmp" ]; then
                mnt_pkg_dir=$(echo $pkg_dir | sed 's/^\/var/\/hostvar/1')
                local_copy_file $img_pkg $mnt_pkg_dir/.
            else
                is_virtfs_enabled=`sysctl -nq $IS_VIRTFS_ENABLED_SYSCTL`
                if [ "$is_virtfs_enabled" == "1" ]; then
                    echo "File already present in Host. Skipping pushing the image"
                    pkg_dir=`dirname $img_pkg`
                else
                    download_file $img_pkg $pkg_dir/.
                fi
            fi
            [ $? -ne 0 ] && fail=1 && return

            echo "Installing $img_pkg" >> $vjunos_install_log
            echo "Installing $img_pkg" > $vjunos_install_pending
            case ${pkg_name} in
            install-media*.tgz)
                # already untar'd domestic.tgz image
                jinstall_domestic_stripped=1
                ;;
            *)
                jinstall_domestic_stripped=0
                ;;
            esac

            echo "jinstall_domestic_stripped flag is set to $jinstall_domestic_stripped for pkg:${pkg_name}" >> $vjunos_install_log
            echo "RETAIN_PKG_IN_PREINSTALL_PKG_PATH flag is set to $RETAIN_PKG_IN_PREINSTALL_PKG_PATH" >> $vjunos_install_log
            if [ ${jinstall_domestic_stripped} -ne 1 ]; then
                $rsh_cmd $HYPERVISOR "rm -rf $PREINSTALL_PKG_PATH"
                $rsh_cmd $HYPERVISOR "mkdir -p $PREINSTALL_PKG_PATH"
                retval=`$rsh_cmd $HYPERVISOR "tar -C $PREINSTALL_PKG_PATH -xmzf $pkg_dir/$pkg_name > /dev/null 2>&1;"' echo $?'`

                [ $retval -ne 0 ] && fail=1 && return

                # verify signed image
                if [ ${jinstall_signed_image} = 1 ]; then

                    if [ ${verify_image_from_host} -eq 1 ] ; then
                        is_verify_tool_available=`$rsh_cmd $HYPERVISOR "ls $verify_cmd 2> /dev/null"`
                        if [ x${is_verify_tool_available} != x ]; then
                            sig_file=`$rsh_cmd $HYPERVISOR "find $PREINSTALL_PKG_PATH -name jinstall-*.tgz.sig"`
                            retval=`rsh_cmd $HYPERVISOR "$verify_cmd -b -c $PREINSTALL_PKG_PATH/certs.pem $sig_file > /dev/null 2>&1;"' echo $?'`
                            if [ ${retval} -ne 0 ]; then
                                fail=1
                                echo "Validating signature for $pkg_name failed!" 
                                #cleanup package before attempting installation to save space
                                $rsh_cmd $HYPERVISOR "rm -rf $pkg_dir/$pkg_name"
                                $rsh_cmd $HYPERVISOR "rm -rf $PREINSTALL_PKG_PATH"
                                return
                            fi
                            echo "Validating signature for $pkg_name success"
                        fi
                    else
                        echo "Validating signature for $pkg_name in hostos not supported" >> $vjunos_install_log
                        echo "Skipping signature validation for $pkg_name"
                    fi
                    retval=`$rsh_cmd $HYPERVISOR "tar -C $pkg_dir -xmzf $PREINSTALL_PKG_PATH/jinstall-*.tgz > /dev/null 2>&1;"' echo $?'`
                    [ $retval -ne 0 ] && fail=1 && return
                    $rsh_cmd $HYPERVISOR "rm -rf $pkg_dir/$pkg_name"
                else
                    jinstall_domestic_pkg=`$rsh_cmd $HYPERVISOR "find $PREINSTALL_PKG_PATH -name jinstall-*.tgz"`
                    if [ x${jinstall_domestic_pkg} != x ]; then
                        retval=`$rsh_cmd $HYPERVISOR "tar -C $PREINSTALL_PKG_PATH -xmzf $jinstall_domestic_pkg > /dev/null 2>&1;"'echo $?'`
                        if [ $? -ne 0 ]; then
                            fail=1
                            echo "Error: failed to extract jinstall package" 
                        fi
                    fi

                    install_media_pkg=`$rsh_cmd $HYPERVISOR "find $PREINSTALL_PKG_PATH -name install-media-*.tgz"`
                    echo "Install media package found at $install_media_pkg" >> $vjunos_install_log
                    if [ x${install_media_pkg} != x ]; then
                        [ "$RETAIN_PKG_IN_PREINSTALL_PKG_PATH" != "1" ] && \
                            $rsh_cmd $HYPERVISOR "mv $install_media_pkg $pkg_dir/"
                    else
                        fail=1
                        echo "Error: installation package not found"
                        host_delete_image
                        return 1
                    fi
                    conversion_script=`$rsh_cmd $HYPERVISOR "find $PREINSTALL_PKG_PATH -name yocto_conversion.sh"`
                    if [ x${conversion_script} != x ]; then
                        [ "$RETAIN_PKG_IN_PREINSTALL_PKG_PATH" != "1" ] && \
                            $rsh_cmd $HYPERVISOR "mv $conversion_script $pkg_dir/"
                    else
                        echo "Error: conversion_script not found"
                        host_delete_image
                        return 1
                    fi
                    host_conversion_script=`$rsh_cmd $HYPERVISOR "find $PREINSTALL_PKG_PATH -name yocto_host_conversion.sh"`
                    if [ x${host_conversion_script} != x ]; then
                        [ "$RETAIN_PKG_IN_PREINSTALL_PKG_PATH" != "1" ] && \
                            $rsh_cmd $HYPERVISOR "mv $host_conversion_script $pkg_dir/"
                    else
                        echo "Error: host conversion script not found"
                        host_delete_image
                        return 1
                    fi
                    [ "$RETAIN_PKG_IN_PREINSTALL_PKG_PATH" != "1" ] && \
                        $rsh_cmd $HYPERVISOR "rm -rf $pkg_dir/$pkg_name"
                fi
            else
                install_media_pkg=$pkg_dir/$pkg_name # Same as $pkg_dir/install-media-*.tgz
                echo "Install media package is already present at $install_media_pkg" >> $vjunos_install_log
            fi
            #cleanup package before attempting installation to save space
            [ "$RETAIN_PKG_IN_PREINSTALL_PKG_PATH" != "1" ] && \
                $rsh_cmd $HYPERVISOR "rm -rf $PREINSTALL_PKG_PATH"
        fi

        if [ "$RETAIN_PKG_IN_PREINSTALL_PKG_PATH" = "1" ] ; then
            if [ ! -z "$install_media_pkg" ] ; then
                 echo "Invoking host installation on $install_media_pkg" >> $vjunos_install_log
                 host_install_image "$install_media_pkg"
                 [ $? -ne 0 ] && fail=1 && return 1
            else
                 echo "Error: Installation package extraction on host failed"
                 fail=1 && return 1
            fi
        else
            host_install_image "$pkg_dir/install-media-*.tgz"
            [ $? -ne 0 ] && fail=1 && return 1
        fi

        echo "Install completed" >> $vjunos_install_log
    else
        echo "$img_pkg not found, install abort!"
        fail=1
        return 1
    fi

    #cleanup package after installation to save space
    rm -rf ${img_pkg}
    host_delete_image
    return 0
}

#
#Usage:  $0 <image>
#           or
#        $0 -clean-install <image>
#           or
#        $0 -on-primary <image>
#           or
#        $0 -clean-install-with-config <upgrade-config> <image>
#
PKG_CLEAN_INSTALL=""
if [ "$1" = "-clean-install" ] ; then
    PKG_CLEAN_INSTALL="1"
    shift
fi

PKG_ON_PRIMARY=""
if [ "$1" = "-on-primary" ] ; then
    PKG_ON_PRIMARY="1"
    shift
fi

PKG_CLEAN_INSTALL_WITH_CONFIG=""
HOST_CLEAN_INSTALL_CFG_PATH=""
if [ "$1" = "-clean-install-with-config" ] ; then
    PKG_CLEAN_INSTALL_WITH_CONFIG="$2"
    shift
    shift
fi

# For the case where
#    1) $pkg_dir is from "Junos" and
#    2) PREINSTALL_PKG_PATH is from "host",
# retaining package in preinstall-pkg-path saves on maximum space required.
# Otherwise "$pkg_dir" would need to keep extra space when the inner
# package is moved back to it from preinstall-pkg-path.
#
# The responsibility of cleaning up the paths after the operation lies with
# respective domains:
#    1) With Junos for $pkg_dir
#    2) With host for PREINSTALL_PKG_PATH
#
RETAIN_PKG_IN_PREINSTALL_PKG_PATH=0

post_install_jvm_image $1
echo $fail >$vjunos_install_status


#Log all the messages into a log file
) < /dev/null > $vjunos_install_current_log 2>&1 
cat $vjunos_install_current_log
cat $vjunos_install_current_log >> $vjunos_install_log
ret=`cat $vjunos_install_status`
exit ${ret}
