\ Copyright (c) 2015, Juniper Networks, Inc.
\ All Rights Reserved.
\
\ Redistribution and use in source and binary forms, with or without
\ modification, are permitted provided that the following conditions
\ are met:
\ 1. Redistributions of source code must retain the above copyright
\    notice, this list of conditions and the following disclaimer.
\ 2. Redistributions in binary form must reproduce the above copyright
\    notice, this list of conditions and the following disclaimer in the
\    documentation and/or other materials provided with the distribution.
\
\ THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
\ ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
\ IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
\ ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
\ FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
\ DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
\ OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
\ HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
\ LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
\ OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
\ SUCH DAMAGE.
\

marker platform-loader.4th

get-current ( -- wid )

vocabulary junos-ubenv
only forth also support-functions also file-processing also parser
also junos-ubenv definitions

hide
\ vocabulary: junos-ubenv - private definitions

string ubenv_import
string ubenv_var

: colon?  line_pointer c@ [char] : = ;

: uboot_parse_: ( addr len -- addr' len-x addr x | addr len addr len )
	2dup [char] : strchr dup if
		rot over - -rot swap 1+ swap 1- 2swap
	else
		2drop 2dup
	then
	;

: read_ubenv_var ( -- addr/len )
	line_pointer
	begin
		end_of_line? if
			0
		else
			letter? digit? underscore? dot? colon? or or or or
		then
	while
		skip_character
	repeat
	space? end_of_line? or invert if ESYNTAX throw then
	line_pointer over -
	name_buffer string=
	;

: ubenv_import_var ( -- )
	ubenv_import strget
	name_buffer strget uboot_parse_: 2swap 2drop
	strcat
	evaluate
	;

set-current
\ vocabulary: junos-ubenv - public definitions

also line-reading

\ For each word in "import_uboot" variable, we try to import a variable of the
\ same name from the U-Boot environment
\
\ Where "ubenv import" would create a uboot.<var-name>, we take that value,
\ and set it into the loader environment as <var-name>, if it is not already
\ set. Then the uboot.<var-name> variable is unset in the loader environment,
\ so as to not polute the environment unnecessarily.
: import-uboot ( -- )
	s" import_uboot" getenv dup -1 = if
		drop
	else
		\ Allocate space
		256 allocate if ENOMEM throw then
		0 s" ubenv import " strcat ubenv_import strset
		256 allocate if ENOMEM throw then
		0 s" uboot." strcat ubenv_var strset

		\ Initialize the line buffer
		line_buffer strfree
		line_buffer_resize
		append_to_line_buffer

		\ Initialize end of line and line pointer
		line_buffer strget + to end_of_line
		line_buffer .addr @ to line_pointer

		\ Iterate over words in the import_uboot variable
		begin
			end_of_line? 0=
		while
			eat_space
			read_ubenv_var
			s" DEBUG" getenv? if
				." Importing from U-Boot: "
				name_buffer strget uboot_parse_:
				type ."  -> " type
			then
			name_buffer strget getenv? invert if
				\ Import the uboot environment
				ubenv_import_var

				\ Build the uboot.<var> name and get the value
				name_buffer strget uboot_parse_:
				ubenv_var strget 2swap strcat
				2dup getenv dup -1 = 0= if
					\ Unset the uboot.<var> variable
					2swap unsetenv

					\ Set the <var> variable
					2swap setenv

					s" DEBUG" getenv? if
						."  (Imported)" cr
					then
				else
					drop 2drop 2drop
					s" DEBUG" getenv? if
						."  (Skipped, no value)" cr
					then
				then
			else
				s" DEBUG" getenv? if
					."  (Skipped, already set)" cr
				then
			then
		repeat

		\ Unset import_uboot variable (to not polute the environment)
		s" import_uboot" unsetenv

		\ Free the allocated strings
		line_buffer strfree
		ubenv_import strfree
		ubenv_var strfree
	then
	;

previous
\ vocabulary: junos-ubenv - end of definitions

only forth definitions
also junos-ubenv

\ words exported to forth-wordlist
: platform-conf-files-read ( -- )
	import-uboot
	;

only forth
set-current ( wid -- )

