\ Copyright (c) 2015, 2019, Juniper Networks, Inc
\ All Rights Reserved.
\

marker platform-load-dtb.4th

get-current ( -- wid )

only forth definitions also dtb

\ We will try to prune at most the following number of dash extensions to
\ the hw.board.name value
10 value .max_load_dtb_prunes

: platform-load-dtb ( -- )
	s" DEBUG" getenv? if ." Loading platform DTB file ..." cr then
	s" hw.board.name" getenv dup -1 = if
		s" No hw.board.name found" type cr
		drop
	else
		2dup load-dtb
		\ Load all the possible variant names for the DTB file by
		\ pruning off last dash and anything after it.
		\ This loop is limited by .max_load_dtb_prunes value.
		.max_load_dtb_prunes 0 do
			2dup [char] - strrchr dup if
				\ Check if it is -c, if so stop. We do this as
				\ we have "compact" platforms that use a name
				\ that has -c in it, so we want to stop there.
				2dup s" -c" compare 0= if
					2drop leave
				then
				swap drop -
				2dup load-dtb
			else
				leave
			then
		loop
		2drop
	then
	;

only forth
set-current ( wid -- )

