\ Copyright (c) 2015, Juniper Networks, Inc.
\ All Rights Reserved.
\

marker load-dtb.4th

get-current ( -- wid )

vocabulary dtb
only forth also support-functions also file-processing also dtb definitions

: load-dtb ( str/len -- )
	s" DEBUG" getenv? if
		." Candidate DTB file: " 2dup type ." .dtb" cr
	then

	\ Save the DTB base name in name_buffer
	2dup name_buffer string=

	\ Allocate space for the DTB file name
	256 allocate if ENOMEM throw then
	0 2swap strcat s" .dtb" strcat

	\ Save address of buffer to free later
	over -rot

	\ Enable module, set load name, set type to dtb
	get_module_option module.loadname string=
	true get_module_option module.flag !
	s" dtb" get_module_option module.type string=

	\ Free memory used
	free-memory
	;

only forth
set-current ( wid -- )

